-- format: { <beat>, <command> }
local LuaMods = {
{132, 'WhiteBG200'},
{215, 'WhiteBG132'},
{520, 'WhiteBG180'},
{583, 'WhiteBG2002'},
{552, 'WhiteBGFinal'},
{583, 'WhiteBGFinalLeave'},
}

--initial beat
table.insert(LuaMods, {4, 'WhiteBeat200'})
table.insert(LuaMods, {4.15, 'HardcoreBeat'})
table.insert(LuaMods, {5.95, 'WhiteBeat200Leaves'})
table.insert(LuaMods, {5.95, 'HardcoreBeatLeaves'})

--default beat circles at the beginning
for b=20,64,2
do
	table.insert(LuaMods, {b, 'WhiteBeat200'})
	table.insert(LuaMods, {b+0.15, 'HardcoreBeat'})
	table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
	table.insert(LuaMods, {b+1.95, 'HardcoreBeatLeaves'})
end

--Hardtek > Frenchcore > Artcore > Metal beat circles
for b=68,130,2
do
	if b >= 68 and b < 84 then
		table.insert(LuaMods, {b, 'WhiteBeat200'})
		table.insert(LuaMods, {b+0.15, 'HardtekBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'HardtekBeatLeaves'})
	end
	
	if b >= 84 and b < 100 then
		table.insert(LuaMods, {b, 'WhiteBeat200'})
		table.insert(LuaMods, {b+0.15, 'FrenchcoreBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'FrenchcoreBeatLeaves'})
	end
	
	if b >= 100 and b < 116 then
		table.insert(LuaMods, {b, 'WhiteBeat200'})
		table.insert(LuaMods, {b+0.15, 'ArtcoreBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'ArtcoreBeatLeaves'})
	end
	
	if b >= 116 and b < 132 then
		table.insert(LuaMods, {b, 'WhiteBeat200'})
		table.insert(LuaMods, {b+0.15, 'MetalBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'MetalBeatLeaves'})
	end
end

--First break beats
for b=148,176,4
do
	table.insert(LuaMods, {b, 'WhiteBeat100'})
	table.insert(LuaMods, {b+0.15, 'HardcoreHalfBeat'})
	table.insert(LuaMods, {b+3.95, 'WhiteBeat100Leaves'}) --had to end it early to avoid epilepsy
	table.insert(LuaMods, {b+3.95, 'HardcoreHalfBeatLeaves'})
end

--Build-up beats
for b=200,212,2
do
	table.insert(LuaMods, {b, 'WhiteBeat132'})
	table.insert(LuaMods, {b+0.15, 'BlackBeat'})
	table.insert(LuaMods, {b+1.95, 'WhiteBeat132Leaves'}) --had to end it early to avoid epilepsy
	table.insert(LuaMods, {b+1.95, 'BlackBeatLeaves'})
end

--Complextro beats
for b=216,238,2
do
	table.insert(LuaMods, {b, 'WhiteBeat132'})
	table.insert(LuaMods, {b+0.15, 'ComplextroBeat'})
	table.insert(LuaMods, {b+1.95, 'WhiteBeat132Leaves'}) --had to end it early to avoid epilepsy
	table.insert(LuaMods, {b+1.95, 'ComplextroBeatLeaves'})
end

--special ending Complextro beats
table.insert(LuaMods, {240, 'WhiteBeatComplextro'})
table.insert(LuaMods, {240.15, 'ComplextroBeat2'})
table.insert(LuaMods, {241.45, 'WhiteBeatComplextroLeaves'}) --had to end it early to avoid epilepsy
table.insert(LuaMods, {241.45, 'ComplextroBeat2Leaves'})

table.insert(LuaMods, {241.5, 'WhiteBeatComplextro'})
table.insert(LuaMods, {241.65, 'ComplextroBeat2'})
table.insert(LuaMods, {242.95, 'WhiteBeatComplextroLeaves'}) --had to end it early to avoid epilepsy
table.insert(LuaMods, {242.95, 'ComplextroBeat2Leaves'})

table.insert(LuaMods, {243, 'WhiteBeat132'})
table.insert(LuaMods, {243.15, 'ComplextroBeat'})
table.insert(LuaMods, {244.95, 'WhiteBeat132Leaves'}) --had to end it early to avoid epilepsy
table.insert(LuaMods, {244.95, 'ComplextroBeatLeaves'})

table.insert(LuaMods, {246, 'WhiteBeat132'})
table.insert(LuaMods, {246.15, 'ComplextroBeat'})
table.insert(LuaMods, {247.95, 'WhiteBeat132Leaves'}) --had to end it early to avoid epilepsy
table.insert(LuaMods, {247.95, 'ComplextroBeatLeaves'})

--remaining genres from Melodic Progressive House > Drumstep
for b=248,518,2
do
	if b >= 248 and b < 280 then
		table.insert(LuaMods, {b, 'WhiteBeat132'})
		table.insert(LuaMods, {b+0.15, 'MelodicProgressiveHouseBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat132Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'MelodicProgressiveHouseBeatLeaves'})
	end
	
	if b >= 280 and b < 312 then
		table.insert(LuaMods, {b, 'WhiteBeat140'})
		table.insert(LuaMods, {b+0.15, 'TranceBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat140Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'TranceBeatLeaves'})
	end
	
	if b >= 312 and b < 344 then
		table.insert(LuaMods, {b, 'WhiteBeat150'})
		table.insert(LuaMods, {b+0.15, 'PsychedelicTranceBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat150Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'PsychedelicTranceBeatLeaves'})
	end
	
	if b >= 344 and b < 360 then
		table.insert(LuaMods, {b, 'WhiteBeat150'})
		table.insert(LuaMods, {b+0.15, 'HardstyleBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat150Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'HardstyleBeatLeaves'})
	end
	
	if b >= 360 and b < 376 then
		table.insert(LuaMods, {b, 'WhiteBeat150'})
		table.insert(LuaMods, {b+0.15, 'PsystyleBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat150Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'PsystyleBeatLeaves'})
	end
	
	if b >= 376 and b < 392 then
		table.insert(LuaMods, {b, 'WhiteBeat150'})
		table.insert(LuaMods, {b+0.15, 'DubstepBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat150Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'DubstepBeatLeaves'})
	end
	
	if b >= 392 and b < 408 then
		table.insert(LuaMods, {b, 'BlackBeat150'})
		table.insert(LuaMods, {b+0.15, 'ColourBassBeat'})
		table.insert(LuaMods, {b+1.95, 'BlackBeat150Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'ColourBassBeatLeaves'})
	end
	
	if b >= 408 and b < 424 then
		table.insert(LuaMods, {b, 'WhiteBeat160'})
		table.insert(LuaMods, {b+0.15, 'HiTechFullOnBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat160Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'HiTechFullOnBeatLeaves'})
	end
	
	if b >= 424 and b < 440 then
		table.insert(LuaMods, {b, 'WhiteBeat160'})
		table.insert(LuaMods, {b+0.15, 'JukeFootworkBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat160Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'JukeFootworkBeatLeaves'})
	end
	
	if b >= 440 and b < 456 then
		table.insert(LuaMods, {b, 'WhiteBeat80'})
		table.insert(LuaMods, {b+0.15, 'LofiHipHopBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat80Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'LofiHipHopBeatLeaves'})
	end
	
	if b >= 456 and b < 488 then
		table.insert(LuaMods, {b, 'WhiteBeat170'})
		table.insert(LuaMods, {b+0.15, 'KawaiiFutureBassBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat170Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'KawaiiFutureBassBeatLeaves'})
	end
	
	if b >= 488 and b < 520 then
		table.insert(LuaMods, {b, 'WhiteBeat180'})
		table.insert(LuaMods, {b+0.15, 'DrumstepBeat'})
		table.insert(LuaMods, {b+1.95, 'WhiteBeat180Leaves'}) --had to end it early to avoid epilepsy
		table.insert(LuaMods, {b+1.95, 'DrumstepBeatLeaves'})
	end
end

--Hardcore beats
for b=584,646,2
do
	table.insert(LuaMods, {b, 'WhiteBeat200'})
	table.insert(LuaMods, {b+0.15, 'HardcoreBeat'})
	table.insert(LuaMods, {b+1.95, 'WhiteBeat200Leaves'}) --had to end it early to avoid epilepsy
	table.insert(LuaMods, {b+1.95, 'HardcoreBeatLeaves'})
end

table.insert(LuaMods, {648, 'WhiteBeat100'})
table.insert(LuaMods, {648.15, 'HardcoreHalfBeat'})
table.insert(LuaMods, {651.95, 'WhiteBeat100Leaves'}) --had to end it early to avoid epilepsy
table.insert(LuaMods, {651.95, 'HardcoreHalfBeatLeaves'})

table.insert(LuaMods, {680, 'Outrotext'})
table.insert(LuaMods, {704, 'OutrotextLeaves'})

-- helper function to convert beats -> seconds based on given BPM
local function TimeInBeats(beats,bpm)
  return 60 / bpm * beats
  end;

scw=SCREEN_WIDTH
sch=SCREEN_HEIGHT


local t = Def.ActorFrame {
-----------
-------------
--whitebg stuff
	Def.Sprite{
		Name="WhiteBG200";
		Texture="whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBG200Command=function(self)
			self:visible(1)
			self:setsize(scw,sch)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:decelerate(TimeInBeats(1.5,200))
			self:zoomy(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBG132";
		Texture="whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBG132Command=function(self)
			self:visible(1)
			self:setsize(scw,sch)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:decelerate(TimeInBeats(1,132))
			self:zoomy(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBG180";
		Texture="whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBG180Command=function(self)
			self:visible(1)
			self:setsize(scw,sch)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:decelerate(TimeInBeats(4,180))
			self:zoomy(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBG2002";
		Texture="whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBG2002Command=function(self)
			self:visible(1)
			self:setsize(scw,sch)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:decelerate(TimeInBeats(1,200))
			self:zoomy(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBGFinal";
		Texture="whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBGFinalCommand=function(self)
			self:visible(1)
			self:diffusealpha(0)
			self:setsize(scw,sch)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:linear(TimeInBeats(8,192))
			self:diffusealpha(0.25)
			self:linear(TimeInBeats(8,195))
			self:diffusealpha(0.50)
			self:linear(TimeInBeats(8,198))
			self:diffusealpha(0.75)
			self:linear(TimeInBeats(7,200))
			self:diffusealpha(1)
		end;
		WhiteBGFinalLeaveCommand=function(self)
			self:visible(0)
		end;
	};

--Beat Circles bg stuff
	--White Circle used in all genres (except Colour Bass)
	Def.Sprite{
		Name="WhiteBeat200";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat200Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,200))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat200LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat100";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat100Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(3.95,200))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat100LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat132";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat132Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,132))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat132LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--Special beat for Complextro ending
	Def.Sprite{
		Name="WhiteBeatComplextro";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeatComplextroCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.45,132))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeatComplextroLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat140";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat140Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,140))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat140LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat150";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat150Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,150))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat150LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat160";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat160Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,160))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat160LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat80";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat80Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,80))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat80LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat170";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat170Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,170))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat170LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteBeat180";
		Texture="beat/WhiteBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBeat180Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,180))
			self:zoom(1.4)
			self:linear(0)
			self:zoom(0)
		end;
		WhiteBeat180LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--Hardcore Beat
	Def.Sprite{
		Name="HardcoreBeat";
		Texture="beat/HardcoreBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardcoreBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		HardcoreBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="HardcoreHalfBeat";
		Texture="beat/HardcoreBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardcoreHalfBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(3.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		HardcoreHalfBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	
	--Hardtek Beat
	Def.Sprite{
		Name="HardtekBeat";
		Texture="beat/HardtekBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardtekBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		HardtekBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--Frenchcore Beat
	Def.Sprite{
		Name="FrenchcoreBeat";
		Texture="beat/FrenchcoreBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		FrenchcoreBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		FrenchcoreBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--Artcore Beat
	Def.Sprite{
		Name="ArtcoreBeat";
		Texture="beat/ArtcoreBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ArtcoreBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		ArtcoreBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--Metal Beat
	Def.Sprite{
		Name="MetalBeat";
		Texture="beat/MetalBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		MetalBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,200))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		MetalBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="BlackBeat";
		Texture="beat/BlackBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BlackBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,132))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		BlackBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	--For Colour Bass
	Def.Sprite{
		Name="BlackBeat150";
		Texture="beat/BlackBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BlackBeat150Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.95,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		BlackBeat150LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="ComplextroBeat";
		Texture="beat/ComplextroBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ComplextroBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,132))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		ComplextroBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="ComplextroBeat2";
		Texture="beat/ComplextroBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ComplextroBeat2Command=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.30,132))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		ComplextroBeat2LeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="MelodicProgressiveHouseBeat";
		Texture="beat/MelodicProgressiveHouseBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		MelodicProgressiveHouseBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,132))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		MelodicProgressiveHouseBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};

	Def.Sprite{
		Name="TranceBeat";
		Texture="beat/TranceBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		TranceBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,140))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		TranceBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};

	Def.Sprite{
		Name="TranceBeat";
		Texture="beat/TranceBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		TranceBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,140))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		TranceBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="PsychedelicTranceBeat";
		Texture="beat/PsychedelicTranceBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		PsychedelicTranceBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		PsychedelicTranceBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="HardstyleBeat";
		Texture="beat/HardstyleBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardstyleBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		HardstyleBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="PsystyleBeat";
		Texture="beat/PsystyleBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		PsystyleBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		PsystyleBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="DubstepBeat";
		Texture="beat/DubstepBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		DubstepBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		DubstepBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="ColourBassBeat";
		Texture="beat/ColourBassBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ColourBassBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,150))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		ColourBassBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="HiTechFullOnBeat";
		Texture="beat/HiTechFullOnBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HiTechFullOnBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,160))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		HiTechFullOnBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="JukeFootworkBeat";
		Texture="beat/JukeFootworkBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		JukeFootworkBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,160))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		JukeFootworkBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="LofiHipHopBeat";
		Texture="beat/LofiHipHopBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		LofiHipHopBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,80))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		LofiHipHopBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="KawaiiFutureBassBeat";
		Texture="beat/KawaiiFutureBassBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		KawaiiFutureBassBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,170))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		KawaiiFutureBassBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="DrumstepBeat";
		Texture="beat/DrumstepBeat.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		DrumstepBeatCommand=function(self)
			self:zoom(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:visible(1)
			self:decelerate(TimeInBeats(1.80,170))
			self:zoom(1.41)
			self:linear(0)
			self:zoom(0)
		end;
		DrumstepBeatLeavesCommand=function(self)
			self:visible(0)
		end;
	};
	
	Def.Sprite{
		Name="Outro-text";
		Texture="Outro-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		OutrotextCommand=function(self)
			self:visible(1)
			self:diffusealpha(0)
			self:zoom(0.5)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:decelerate(TimeInBeats(8,200))
			self:diffusealpha(1)
		end;
		OutrotextLeavesCommand=function(self)
			self:linear(TimeInBeats(8,200))
			self:diffusealpha(0)
		end;
	};
	
	

  -- DO NOT TOUCH ANY OF THIS UNLESS YOU KNOW WHAT YOU'RE DOING
  InitCommand = function (self)

  	self:SetDrawByZPosition(true)
    -- table to keep track of mods already finished
    local completed = {}


    for _, mod in ipairs(LuaMods) do
      local beat = unpack(mod)
      if GAMESTATE:GetSongBeat() > beat then
        completed[mod] = true
      end
    end



    -- hOBOI
    self:SetUpdateFunction(function()
      MESSAGEMAN:Broadcast("Update")
      local curbeat = GAMESTATE:GetSongBeat()
      local circlepos = curbeat / 2 * math.pi


      -- this is significantly easier *sigh*
      for _, mod in ipairs(LuaMods) do
        local beat, command = unpack(mod)
        if curbeat > beat and not completed[mod] then
          self:playcommand(command, unpack(mod, 3))
          completed[mod] = true
        end
      end
      end)
    end;

    OnCommand=function(self)

    self:SetDrawByZPosition(true)

    -- keep the FG change alive
    self:sleep(9999)
    end;
  }

  return t